
//
// To jest przykadowy kod z podrozdziau 19.3.6 Uoglnianie wektora ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

//------------------------------------------------------------------------------
// Prawie prawdziwy wektor elementw typu T:
template<class T> class vector {      // Czytaj: dla wszystkich typw T (tak jak w matematyce).
    int sz;                           // rozmiar
    T* elem;                          // wskanik na elementy
    int space;                        // size+free_space
public:
    vector() : sz(0), elem(0), space(0) { }    
    vector(int s);

    vector(const vector&);            // konstruktor kopiujcy
    vector& operator=(const vector&); // przypisanie kopiujce

    ~vector() { delete[ ] elem; }     // destruktor

    T& operator[ ] (int n) { return elem[n]; } // dostp: zwraca referencj
    const T& operator[ ] (int n) const { return elem[n]; }  

    int size() const { return sz; }   // aktualny rozmiar
    int capacity() const { return space; }

    void resize(int newsize, T def = T()); // wzrost
    void push_back(const T& d);
    void reserve(int newalloc);
};

//------------------------------------------------------------------------------

struct No_default {
    No_default(int);               // Jedyny konstruktor struktury No_default.
    // ...
};

//------------------------------------------------------------------------------

int main(int argc, char* argv[])
{
    vector<double> v1;
    v1.resize(100);                // Dodaje 100 kopii double(), tzn. 0.0.
    v1.resize(200, 0.0);           // Dodaje 100 kopii 0.0  wpisanie 0.0 byo zbdne.
    v1.resize(300, 1.0);           // Dodaje 100 kopii 1.0.

    //vector<No_default> v2(10);   // Bd: prba utworzenia 10 obiektw No_default().

    vector<No_default> v3;
    v3.resize(100, No_default(2)); // Dodaje 100 kopii No_default(2).
    //v3.resize(200);              // Bd: prba utworzenia 100 obiektw No_default().
}

//------------------------------------------------------------------------------
